package au.victory.iia.geoquiz;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class QuizActivity extends AppCompatActivity {

    private static final String TAG = "QuizActivity";
    private static final String KEY_INDEX = "index";

    private Button mTrueButton;
    private Button mFalseButton;
    private Button mNextButton;
    private Button mRetakeButton;
    private TextView mQuestionTextView;

    private Question[] mQuestionBank = new Question[]{
            new Question(R.string.question_australia, true),
            new Question(R.string.question_oceans, true),
            new Question(R.string.question_mideast, false),
            new Question(R.string.question_africa, false),
            new Question(R.string.question_americas, true),
            new Question(R.string.question_asia, true),
    };

    private int mCurrentIndex = 0;
    private int score=0;
    private boolean mQuestionAnswered = false;


    private boolean[] QuestionsAnswered = new boolean[mQuestionBank.length];

    @Override
    protected void onCreate(final Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d(TAG,"onCreate(Bundle) called");
        setContentView(R.layout.activity_quiz);
        if (savedInstanceState != null) {
         mCurrentIndex =savedInstanceState.getInt(KEY_INDEX, 0);
         QuestionsAnswered = savedInstanceState.getBooleanArray(KEY_INDEX);
        }

         mQuestionTextView = (TextView)findViewById(R.id.question_text_view);



    mTrueButton = (Button)findViewById(R.id.true_button);
        mTrueButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mQuestionAnswered=true;
               checkAnswer(true);
            }
        });


        mFalseButton = (Button)findViewById(R.id.false_button);

        mFalseButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mQuestionAnswered=true;
              checkAnswer(false);
            }
        });

        mNextButton = (Button)findViewById(R.id.next_button);

        mNextButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCurrentIndex = (mCurrentIndex+mQuestionBank.length +1) % mQuestionBank.length;
                updateQuestion();
                if (mCurrentIndex==(mQuestionBank.length-1)%mQuestionBank.length){
                    mNextButton.setEnabled(false);
                }
//                if (mQuestionAnswered=true){
//                    mNextButton.setEnabled(true);
//                }else {
//                    mNextButton.setEnabled(false);
//                }
                updateQuestion();
                Log.d(TAG,"Lastq"+mCurrentIndex);
            }
        });

    mRetakeButton = (Button)findViewById(R.id.retake_button);
        mRetakeButton.setVisibility(View.INVISIBLE);
    mRetakeButton.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
         onCreate(savedInstanceState);
        }
    });
}

    @Override
    protected void onStart() {
        super.onStart();
        Log.d(TAG, "onStart() called");
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d(TAG, "onResume() called");
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d(TAG, "onPause() called");
    }

    @Override
    protected void onSaveInstanceState(Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);
        savedInstanceState.putInt(KEY_INDEX,mCurrentIndex);
        savedInstanceState.putBooleanArray(KEY_INDEX,QuestionsAnswered);
    }

    @Override
    protected void onStop() {
        super.onStop();
        Log.d(TAG, "onStop() called");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy() called");
    }

    private void updateQuestion(){
        int question = mQuestionBank[mCurrentIndex].getTextResId();
        mQuestionTextView.setText(question);
        mTrueButton.setEnabled(!QuestionsAnswered[mCurrentIndex]);
        mFalseButton.setEnabled(!QuestionsAnswered[mCurrentIndex]);

    }

    private void checkAnswer(boolean userPressedTrue) {
        boolean answerIsTrue = mQuestionBank[mCurrentIndex].isAnswerTrue();
        int messageResId = 0;

        if (userPressedTrue == answerIsTrue) {
            messageResId = R.string.correct_toast;
            score++;
        }
        else {
            messageResId = R.string.incorrect_toast;
        }

        if (mCurrentIndex == mQuestionBank.length-1){
            Score();
            mNextButton.setEnabled(false);
        }


        Toast.makeText(this, messageResId, Toast.LENGTH_LONG).show();
        QuestionsAnswered[mCurrentIndex] = true;
        mTrueButton.setEnabled(false);
        mFalseButton.setEnabled(false);
    }
    private void Score(){
        score = score*100/(mQuestionBank.length);
        Toast toast = Toast.makeText(QuizActivity.this, "Your result is "+ score + "%",Toast.LENGTH_LONG);
        toast.setGravity(0,0,30);
        toast.show();
        mRetakeButton.setVisibility(View.VISIBLE);
    }
}
